#include <stdio.h>
#include <assert.h>
#include <string.h>
#include <windows.h>
//#include "resource.h"
  
double const PI = 3.14159265358979323846;

HINSTANCE dllInstance;

class CCBWaveEditor {
public:
	// General Functions
	virtual HWND    GetMainBuzzWindow();
	virtual HWND    GetWaveTableWindow();

	// Wave Table Entries - General
	virtual int     CreateNewEntry(int samplesize, char * name);
	virtual int     GetNumOfNotes(int index);
	virtual bool    IsThereSample(int index);

	// Wave Table Entries - Retrieving
	virtual char  * GetSampleName(int index);
	virtual short * GetSamples(int index, int note);
	virtual int     GetNumSamples(int index, int note);
	virtual int     GetNumChannels(int index);
	virtual int     GetLoopStart(int index, int note);
	virtual int     GetLoopEnd(int index, int note);
	virtual int     GetSamplerate(int index, int note);
	virtual int     GetRootNote(int index, int note);
	virtual float   GetVolume(int index);
	virtual bool    IsLooped(int index);

	// Wave Table Entries - Setting
	virtual int     SetNumChannels(int index, int value);
	virtual int     SetLoopStart(int index, int note, int value);
	virtual int     SetLoopEnd(int index, int note, int value);
	virtual int     SetSamplerate(int index, int note, int value);
	virtual int     SetRootNote(int index, int note, int value);
	virtual int     SetVolume(int index, float value);
	virtual int     SetLooped(int index, bool value);

//	// New Functions - 24\32 bit related
	virtual int     SetTo16BitPCM   (int index);
	virtual int     SetTo32BitFloat (int index);
	virtual int     CreateSpecificEntry(int index, int samplesize, char * name);
	virtual HWND	GetFileBrowserWnd();

	virtual void     WavePlayerReserve();
	virtual float *  WavePlayerCreateBuffer(int samplesize, int samplerate);
	virtual void     WavePlayerPlay();

	virtual void SetSampleName(int position, char * newname);

	virtual int     SetTo32BitPCM (int index);
	virtual int     SetTo24BitPInt (int index);
	virtual int     GetSampleType (int index);
	virtual int     SetSampleType (int index, int type);

};

class CWaveEditor {
public:
	virtual bool __cdecl Init(CCBWaveEditor *pCCB);

	virtual int  __cdecl GetNumOfCommands();
	virtual bool __cdecl EnumerateCommands(int index, char * buffer);

	virtual bool __cdecl Start(int commandindex, int selected);

	virtual void __cdecl DispatchCommand(int command_id, int param1, int param2, int param3, int param4);
	virtual void __cdecl DispatchCommandEx(char * str_command, char * str_value);
	virtual int __cdecl WaveEditorVersion();
	virtual void GetExtensionsClass(int param, void **exmodule);
};

class edit : public CWaveEditor {
public:
	virtual bool __cdecl Init(CCBWaveEditor *pCCB);

	virtual int  __cdecl GetNumOfCommands();
	virtual bool __cdecl EnumerateCommands(int index, char * buffer);

    virtual bool __cdecl Start(int commandindex, int selected);

	// user defined

	virtual void routine_load(int selected);
	//

	virtual void __cdecl DispatchCommand(int command_id, int param1, int param2, int param3, int param4);
	virtual void __cdecl DispatchCommandEx(char * str_command, char * str_value);
	virtual int __cdecl WaveEditorVersion() { return 100; };
	virtual void GetExtensionsClass(int param, void **exmodule) { };
private:
	CCBWaveEditor * pCB;

public:
	// user defined stuff
	char samplename[255];
	int set_numchan;
	int set_type;
	bool cancelled;
};

bool edit::Init(CCBWaveEditor *pCCB) {
	pCB = pCCB; // this is for the way to call back and get things
	return true;
}

int  edit::GetNumOfCommands() {
	return 1;
}

bool edit::EnumerateCommands(int index, char * buffer) {
	if (index < 0) return false;
	if (index > 2) return false;
	switch (index) {
	case 0: strcpy(buffer, "Switch to 32"); break;
	default:
		return false;
		break;
	}
	return true;
}

//////////////////////////////////////////
// Wave Editor Routines That actually does
// Things
//////////////////////////////////////////

edit *g_edit;

BOOL APIENTRY SettingsDialog(HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam) {
/*	switch(uMsg) {
	case WM_INITDIALOG:
		g_edit->cancelled = true;

		SetDlgItemText (hDlg, IDC_SAMPLENAME, g_edit->samplename);

		SendMessage(GetDlgItem(hDlg, IDC_DATATYPE), CB_RESETCONTENT, 0, 0);
		SendMessage(GetDlgItem(hDlg, IDC_DATATYPE), CB_ADDSTRING,0,(LPARAM)(LPCTSTR)("16-bit integer (intel)"));
		SendMessage(GetDlgItem(hDlg, IDC_DATATYPE), CB_ADDSTRING,0,(LPARAM)(LPCTSTR)("16-bit integer (motorola)"));
		SendMessage(GetDlgItem(hDlg, IDC_DATATYPE), CB_ADDSTRING,0,(LPARAM)(LPCTSTR)("32-bit float"));
		SendMessage(GetDlgItem(hDlg, IDC_DATATYPE), CB_SETCURSEL, (int)(g_edit->set_type), 0);

		SendMessage(GetDlgItem(hDlg, IDC_CHANNELS), CB_RESETCONTENT, 0, 0);
		SendMessage(GetDlgItem(hDlg, IDC_CHANNELS), CB_ADDSTRING,0,(LPARAM)(LPCTSTR)("Mono"));
		SendMessage(GetDlgItem(hDlg, IDC_CHANNELS), CB_ADDSTRING,0,(LPARAM)(LPCTSTR)("Stereo"));
		SendMessage(GetDlgItem(hDlg, IDC_CHANNELS), CB_SETCURSEL, (int)(g_edit->set_numchan), 0);
		return 1;
	case WM_SHOWWINDOW: return 1;
	case WM_CLOSE: EndDialog (hDlg, TRUE);
	case WM_COMMAND:
		switch ( LOWORD (wParam))
		{
		case IDOK:
			g_edit->cancelled = false;
			GetDlgItemText (hDlg, IDC_SAMPLENAME, g_edit->samplename, 255);
			g_edit->set_type = (int)SendMessage(GetDlgItem(hDlg, IDC_DATATYPE), CB_GETCURSEL, 0, 0);
			g_edit->set_numchan = (int)SendMessage(GetDlgItem(hDlg, IDC_CHANNELS), CB_GETCURSEL, 0, 0);
			EndDialog(hDlg, TRUE);
			return 1;
		case IDCANCEL:
			g_edit->cancelled = true;
			EndDialog(hDlg, TRUE);
			return 1;
		default:
			return 0;
		}
		break;
	} */
	return 0;
}

//static union {
//	short moto_intbuf;
//	char moto_bbuf[2];
//}; */

void edit::routine_load(int selected) {

	float *      psamples;
	int          nSuccess;
	FILE *       bloader;
	OPENFILENAME ofl;
	char         filename[255];
	int          flength;
	int          samplenum;
	int          num;
	int          i;
	float        fbuf;



	// dialog box code
	sprintf(filename,"\0");
	ofl.lStructSize = sizeof(ofl);
	ofl.hwndOwner = pCB->GetMainBuzzWindow();
	ofl.hInstance = dllInstance;
	ofl.lpstrFilter = "All Files (*.*)\0*.*\0";
	ofl.lpstrCustomFilter = NULL;
	ofl.nMaxCustFilter = NULL;
	ofl.nFilterIndex = 1;
	ofl.lpstrFile = filename;
	ofl.nMaxFile = 255;
	ofl.lpstrFileTitle = NULL;
	ofl.nMaxFileTitle = NULL;
	ofl.lpstrInitialDir = NULL;
	ofl.lpstrTitle = "Load Float Raw File";
	ofl.Flags = OFN_PATHMUSTEXIST|OFN_FILEMUSTEXIST;
	ofl.nFileOffset = 0;
	ofl.nFileExtension = 0;
	ofl.lpstrDefExt = ".raw";
	ofl.lCustData = NULL;
	ofl.lpfnHook = NULL;
	ofl.lpTemplateName = NULL;
	nSuccess = GetOpenFileName(&ofl);
	if (nSuccess == 0) return;
	bloader = fopen(ofl.lpstrFile,"rb");
	fseek(bloader, 0, SEEK_END);
	flength = (ftell(bloader) / 4) * 2;
	fseek(bloader, 0, SEEK_SET);
	sprintf(samplename, "mr. bob wants 32 float");
	samplenum = pCB->CreateNewEntry(flength+4,samplename); // 4 for the extended block
	pCB->SetNumChannels(samplenum, 2);
	pCB->SetTo32BitFloat(samplenum);
	psamples = (float *)pCB->GetSamples(samplenum, 0);
	num = pCB->GetNumSamples(samplenum, 0) / 2;
	for (i = 0; i < num; i++) {
		fread(&fbuf, sizeof(float),1,bloader);
		*psamples = (float)fbuf;
		psamples++;
	}
	fclose(bloader);

}

//////////////////////////////////////////
// End of Wave Editor Routines
//////////////////////////////////////////

bool edit::Start (int commandindex, int selected) {
	switch (commandindex) {
	case 0:
		routine_load(selected);
		return true;
		break;
	default:
		return false;
	}
	return false;
}

void edit::DispatchCommand(int command_id, int param1, int param2, int param3, int param4) {
}

void edit::DispatchCommandEx(char * str_command, char * str_value) {
}

extern "C" {
__declspec(dllexport) CWaveEditor * __cdecl CreateWaveEditor() { return new edit; }
__declspec(dllexport) char * __cdecl WEInfo() { return "Binary Loader"; }
}

BOOL WINAPI DllMain( HANDLE hModule, DWORD fdwreason, LPVOID lpReserved)
{
	switch(fdwreason) {
	case DLL_PROCESS_ATTACH:
		{
		dllInstance = (HINSTANCE) hModule;
		} break;
	case DLL_THREAD_ATTACH: break;
	case DLL_THREAD_DETACH: break;
	case DLL_PROCESS_DETACH: break;
	}
	return TRUE;
}
